<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config_value('site_name', 'Edge')); ?> - <?php echo $__env->yieldContent('title', 'Home'); ?></title>
    <link rel="icon" href="<?php echo e(config_value('site_favicon', asset('images/logo_fix.png'))); ?>" type="image/png">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <!-- Styles -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/scss/app.scss', 'resources/js/app.js']); ?>

    <style>
        :root {
            --primary-color: <?php echo e(config_value('primary_color', '#4B8BFF')); ?>;
            --primary-dark: <?php echo e(config_value('primary_dark', '#4179E6')); ?>;
            --primary-light: <?php echo e(config_value('primary_light', '#80A9FF')); ?>;
        }
    </style>
    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>
    <div class="app-wrapper">
        <header class="main-header">
            <div class="container">
                <div class="header-content">
                    
                    <div class="logo">
                        <a href="<?php echo e(route('home')); ?>">
                            <img src="<?php echo e(config_value('site_logo', asset('images/logo_fix.png'))); ?>" alt="Logo">
                        </a>
                    </div>

                    
                    <nav class="main-nav" id="mainNav">
                        <ul>
                            <li><a href="<?php echo e(route('home')); ?>" class="<?php echo e(request()->routeIs('home') ? 'active' : ''); ?>">Home</a></li>
                            <li><a href="<?php echo e(route('forum.index')); ?>" class="<?php echo e(request()->routeIs('forum.*') ? 'active' : ''); ?>">Forum</a></li>
                            <?php if(!!config_value('store_enabled')): ?>
                                <li><a href="<?php echo e(route('store.index')); ?>" class="<?php echo e(request()->routeIs('store.*') ? 'active' : ''); ?>">Store</a></li>
                            <?php endif; ?>
                            <li class="nav-dropdown">
                                <a href="#" class="<?php echo e(request()->routeIs('community.*') ? 'active' : ''); ?>">
                                    Community <i class="fas fa-chevron-down"></i>
                                </a>
                                <div class="nav-dropdown-menu">
                                    <a href="<?php echo e(route('users.index')); ?>" class="nav-dropdown-item">Users</a>
                                    <a href="<?php echo e(route('map')); ?>" class="nav-dropdown-item">Interactive Map</a>
                                    <?php if(!!config_value('toggle_news')): ?>
                                        <a href="<?php echo e(route('news.index')); ?>" class="nav-dropdown-item">News</a>
                                    <?php endif; ?>
                                </div>
                            </li>
                        </ul>
                    </nav>

                    
                    <div class="header-actions">
                        <?php if(auth()->guard()->check()): ?>
                            
                            <div class="header-notification-container" id="header-notification-container">
                                <button class="header-notification-bell" aria-label="Notifications">
                                    <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                        <path d="M18 8A6 6 0 0 0 6 8c0 7-3 9-3 9h18s-3-2-3-9"></path>
                                        <path d="M13.73 21a2 2 0 0 1-3.46 0"></path>
                                    </svg>
                                    <span class="header-notification-badge is-hidden" id="header-notification-badge">0</span>
                                </button>
                                
                                <div class="header-notification-dropdown" id="header-notification-dropdown">
                                    <div class="header-notification-header">
                                        <h3>Notifications</h3>
                                        <a href="#" class="header-mark-all-read">Mark all read</a>
                                    </div>
                                    
                                    <div class="header-notification-list" id="header-notification-list">
                                        <div class="header-notification-loading">Loading...</div>
                                    </div>
                                    
                                    <div class="header-notification-footer">
                                        <a href="<?php echo e(route('notifications.index')); ?>" class="header-view-all-link">View all notifications</a>
                                    </div>
                                </div>
                            </div>

                            
                            <div class="user-dropdown" id="userDropdown">
                                <div class="user-info">
                                    <img src="<?php echo e(auth()->user()->avatar); ?>" alt="<?php echo e(auth()->user()->name); ?>" class="avatar">
                                    <span><?php echo e(auth()->user()->name); ?></span>
                                </div>
                                <div class="dropdown-menu" id="userDropdownMenu">
                                    <a href="<?php echo e(route('profile.show')); ?>" class="dropdown-item">
                                        <i class="fas fa-user"></i>
                                        <span>Profile</span>
                                    </a>
                                    <a href="<?php echo e(route('notifications.index')); ?>" class="dropdown-item">
                                        <i class="fas fa-bell"></i>
                                        <span>Notifications</span>
                                        <span class="dropdown-notification-badge" id="dropdown-notification-badge" style="display: none;">0</span>
                                    </a>
                                    <a href="<?php echo e(route('store.purchase-history')); ?>" class="dropdown-item">
                                        <i class="fas fa-shopping-cart"></i>
                                        <span>Purchases</span>
                                    </a>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('access dashboard')): ?>
                                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="dropdown-item">
                                            <i class="fas fa-cog"></i>
                                            <span>Admin Panel</span>
                                        </a>
                                    <?php endif; ?>
                                    <form method="POST" action="<?php echo e(route('logout')); ?>">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="dropdown-item">
                                            <i class="fas fa-sign-out-alt"></i>
                                            <span>Logout</span>
                                        </button>
                                    </form>
                                </div>
                            </div>
                        <?php else: ?>
                            
                            <div class="auth-buttons">
                                <a href="<?php echo e(route('login.steam')); ?>" class="btn-steam">
                                    <i class="fa-brands fa-steam"></i> 
                                    <span>Login with Steam</span>
                                </a>
                            </div>
                        <?php endif; ?>

                        
                        <button class="mobile-nav-toggle" aria-label="Toggle menu">
                            <i class="fas fa-bars"></i>
                        </button>
                    </div>
                </div>
            </div>
        </header>

        
        <div class="mobile-menu-overlay" id="mobileMenuOverlay"></div>

        <main class="main-content">
            <?php echo $__env->yieldContent('content'); ?>
        </main>

        <footer class="main-footer">
            <div class="container">
                <div class="footer-content">
                    <div class="footer-logo">
                        <img src="<?php echo e(config_value('site_logo', asset('images/logo_fix.png'))); ?>" alt="Logo">
                        <p><?php echo e(config_value('footer_text')); ?></p>
                    </div>
                    <div class="footer-links">
                        <div class="link-group">
                            <h4>Links</h4>
                            <ul>
                                <li><a href="<?php echo e(route('home')); ?>">Home</a></li>
                                <li><a href="<?php echo e(url('/#servers')); ?>">Servers</a></li>
                                <li><a href="<?php echo e(route('store.index')); ?>">Store</a></li>
                                <li><a href="<?php echo e(route('forum.index')); ?>">Forums</a></li>
                            </ul>
                        </div>
                        <div class="link-group">
                            <h4>Community</h4>
                            <ul>
                                <?php if(config_value('discord_invite') != ""): ?>
                                    <li><a href="<?php echo e(config_value('discord_invite')); ?>">Discord</a></li>
                                <?php endif; ?>
                                <?php if(config_value('steam_group') != ""): ?>
                                    <li><a href="https://steamcommunity.com/group/<?php echo e(config_value('steam_group')); ?>">Steam Group</a></li>
                                <?php endif; ?>
                                <li><a href="<?php echo e(route('users.index')); ?>">Users</a></li>
                            </ul>
                        </div>
                        <?php if(config_value('show_legal_footer', true)): ?>
                        <div class="link-group">
                            <h4>Legal</h4>
                            <ul>
                                <li><a href="<?php echo e(route('store.tos')); ?>">Terms of Service</a></li>
                                <li><a href="<?php echo e(route('privacy.policy')); ?>">Privacy Policy</a></li>
                            </ul>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </footer>
    </div>

    <?php if(auth()->guard()->check()): ?>
    
    <script>
        window.notificationRoutes = {
            recent: '<?php echo e(route('notifications.recent')); ?>',
            unreadCount: '<?php echo e(route('notifications.unread-count')); ?>',
            markAllRead: '<?php echo e(route('notifications.mark-all-read')); ?>',
            markRead: '/notifications/:id/read',
            notificationsIndex: '<?php echo e(route('notifications.index')); ?>'
        };
    </script>
    <?php endif; ?>
    
    <?php echo $__env->yieldPushContent('scripts'); ?>
    <?php echo $__env->yieldPushContent('inline-scripts'); ?>
</body>
</html><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/layouts/app.blade.php ENDPATH**/ ?>